unit WinForm;

//
// In a multi-threaded WinForm application, worker threads cannot directly
// call a control created on the user interface thread. This example
// demonstrates how worker threads can safely update the user interface.
//
// Written by: Rick Ross (http://www.rick-ross.com)
//

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Threading;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnMainThread: System.Windows.Forms.Button;
    btnLaunchThreads: System.Windows.Forms.Button;
    progBarMainThread: System.Windows.Forms.ProgressBar;
    progBarThread1: System.Windows.Forms.ProgressBar;
    progBarThread2: System.Windows.Forms.ProgressBar;
    progBarThread3: System.Windows.Forms.ProgressBar;
    lblMainThread: System.Windows.Forms.Label;
    lblThread1: System.Windows.Forms.Label;
    lblThread2: System.Windows.Forms.Label;
    lblThread3: System.Windows.Forms.Label;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnMainThread_Click(sender: System.Object; e: System.EventArgs);
    procedure btnLaunchThreads_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

  myUpdateDelegate = procedure of object;

  TMyThreadClass = class
  private
   FprogBar : System.Windows.Forms.ProgressBar ;
   Flbl     : System.Windows.Forms.Label;
   nameOfThisThread : string;
   currentPct : integer;

   procedure SafeUpdate; 
  public
   procedure MethodToThread;
   
   property ProgBarToUpdate : System.Windows.Forms.ProgressBar write FprogBar;
   property LabelToUpdate   : System.Windows.Forms.Label       write Flbl;   
  end;

implementation


uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.btnMainThread := System.Windows.Forms.Button.Create;
  Self.btnLaunchThreads := System.Windows.Forms.Button.Create;
  Self.progBarMainThread := System.Windows.Forms.ProgressBar.Create;
  Self.progBarThread1 := System.Windows.Forms.ProgressBar.Create;
  Self.progBarThread2 := System.Windows.Forms.ProgressBar.Create;
  Self.progBarThread3 := System.Windows.Forms.ProgressBar.Create;
  Self.lblMainThread := System.Windows.Forms.Label.Create;
  Self.lblThread1 := System.Windows.Forms.Label.Create;
  Self.lblThread2 := System.Windows.Forms.Label.Create;
  Self.lblThread3 := System.Windows.Forms.Label.Create;
  Self.SuspendLayout;
  // 
  // btnMainThread
  // 
  Self.btnMainThread.Location := System.Drawing.Point.Create(16, 32);
  Self.btnMainThread.Name := 'btnMainThread';
  Self.btnMainThread.Size := System.Drawing.Size.Create(96, 23);
  Self.btnMainThread.TabIndex := 0;
  Self.btnMainThread.Text := 'Main Thread';
  Include(Self.btnMainThread.Click, Self.btnMainThread_Click);
  // 
  // btnLaunchThreads
  // 
  Self.btnLaunchThreads.Location := System.Drawing.Point.Create(16, 152);
  Self.btnLaunchThreads.Name := 'btnLaunchThreads';
  Self.btnLaunchThreads.Size := System.Drawing.Size.Create(96, 23);
  Self.btnLaunchThreads.TabIndex := 1;
  Self.btnLaunchThreads.Text := 'Launch Threads';
  Include(Self.btnLaunchThreads.Click, Self.btnLaunchThreads_Click);
  // 
  // progBarMainThread
  // 
  Self.progBarMainThread.Location := System.Drawing.Point.Create(160, 20);
  Self.progBarMainThread.Name := 'progBarMainThread';
  Self.progBarMainThread.Size := System.Drawing.Size.Create(272, 23);
  Self.progBarMainThread.TabIndex := 2;
  // 
  // progBarThread1
  // 
  Self.progBarThread1.Location := System.Drawing.Point.Create(160, 85);
  Self.progBarThread1.Name := 'progBarThread1';
  Self.progBarThread1.Size := System.Drawing.Size.Create(272, 23);
  Self.progBarThread1.TabIndex := 3;
  // 
  // progBarThread2
  // 
  Self.progBarThread2.Location := System.Drawing.Point.Create(160, 152);
  Self.progBarThread2.Name := 'progBarThread2';
  Self.progBarThread2.Size := System.Drawing.Size.Create(272, 23);
  Self.progBarThread2.TabIndex := 4;
  // 
  // progBarThread3
  // 
  Self.progBarThread3.Location := System.Drawing.Point.Create(160, 216);
  Self.progBarThread3.Name := 'progBarThread3';
  Self.progBarThread3.Size := System.Drawing.Size.Create(272, 23);
  Self.progBarThread3.TabIndex := 5;
  // 
  // lblMainThread
  // 
  Self.lblMainThread.Location := System.Drawing.Point.Create(184, 51);
  Self.lblMainThread.Name := 'lblMainThread';
  Self.lblMainThread.Size := System.Drawing.Size.Create(240, 23);
  Self.lblMainThread.TabIndex := 6;
  Self.lblMainThread.Text := 'Main Thread Percent Complete';
  // 
  // lblThread1
  // 
  Self.lblThread1.Location := System.Drawing.Point.Create(176, 115);
  Self.lblThread1.Name := 'lblThread1';
  Self.lblThread1.Size := System.Drawing.Size.Create(248, 16);
  Self.lblThread1.TabIndex := 7;
  Self.lblThread1.Text := 'Thread # Percent complete';
  // 
  // lblThread2
  // 
  Self.lblThread2.Location := System.Drawing.Point.Create(176, 178);
  Self.lblThread2.Name := 'lblThread2';
  Self.lblThread2.Size := System.Drawing.Size.Create(256, 16);
  Self.lblThread2.TabIndex := 8;
  Self.lblThread2.Text := 'Thread # Percent complete';
  // 
  // lblThread3
  // 
  Self.lblThread3.Location := System.Drawing.Point.Create(176, 245);
  Self.lblThread3.Name := 'lblThread3';
  Self.lblThread3.Size := System.Drawing.Size.Create(240, 16);
  Self.lblThread3.TabIndex := 9;
  Self.lblThread3.Text := 'Thread # Percent complete';
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(456, 277);
  Self.Controls.Add(Self.lblThread3);
  Self.Controls.Add(Self.lblThread2);
  Self.Controls.Add(Self.lblThread1);
  Self.Controls.Add(Self.lblMainThread);
  Self.Controls.Add(Self.progBarThread3);
  Self.Controls.Add(Self.progBarThread2);
  Self.Controls.Add(Self.progBarThread1);
  Self.Controls.Add(Self.progBarMainThread);
  Self.Controls.Add(Self.btnLaunchThreads);
  Self.Controls.Add(Self.btnMainThread);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm Threading Example';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.btnLaunchThreads_Click(sender: System.Object; e: System.EventArgs);
var
  thrdinst1 : TMyThreadClass;
  thrdinst2 : TMyThreadClass;
  thrdinst3 : TMyThreadClass;
  thrd1     : Thread;
  thrd2     : Thread;
  thrd3     : Thread;
begin
  thrdinst1 := TMyThreadClass.Create;
  thrdinst1.LabelToUpdate   := self.lblThread1;
  thrdinst1.ProgBarToUpdate := self.progBarThread1;

  thrdinst2 := TMyThreadClass.Create;
  thrdinst2.LabelToUpdate   := self.lblThread2;
  thrdinst2.ProgBarToUpdate := self.progBarThread2;

  thrdinst3 := TMyThreadClass.Create;
  thrdinst3.LabelToUpdate   := self.lblThread3;
  thrdinst3.ProgBarToUpdate := self.progBarThread3;

  thrd1 := Thread.Create( @thrdinst1.MethodToThread );
  thrd1.Name := 'One';

  thrd2 := Thread.Create( @thrdinst2.MethodToThread );
  thrd2.Name := 'Two';

  thrd3 := Thread.Create( @thrdinst3.MethodToThread );
  thrd3.Name := 'Three';

  thrd1.Start();
  thrd2.Start();
  thrd3.Start();
end;

procedure TWinForm.btnMainThread_Click(sender: System.Object; e: System.EventArgs);
var
  rnd : System.Random;
  i   : integer;

begin
  rnd := System.Random.Create();
  for i:=1 to 100 do
  begin
    Application.DoEvents();
    Thread.Sleep( rnd.Next(500) );
    // update the progress bar
    progBarMainThread.Increment(1);
    lblMainThread.Text := 'Main Thread Percent complete: ' +
                           System.Int32(i).ToString() + '%';
  end;
end;

{ TMyThreadClass }

procedure TMyThreadClass.SafeUpdate;
begin
  FprogBar.Increment(1);
  Flbl.Text := 'Thread ' + nameOfThisThread + ' Percent complete: ' + currentPct.ToString() + '%';
end;

procedure TMyThreadClass.MethodToThread;
var
  rnd : System.Random;
  i : integer;
  myDelegate : myUpdateDelegate;

begin
  rnd := System.Random.Create;
  myDelegate := &self.SafeUpdate;

  nameOfThisThread := Thread.CurrentThread.Name;
  for i:=1 to 100 do
  begin
    Thread.Sleep( rnd.Next(500) );
    currentPct := i;
    FprogBar.Invoke( System.Delegate(@myDelegate) );
  end;
end;


end.
